#!/bin/bash

# First argument: algorithms directory
# Second argument: instances directory
# Third argument: csv result file name

#set -o errexit
set -o nounset
set -o pipefail

PARTICIPANT_ROOT=$1
INSTANCE_DIR=$2
OUTPUT=$3

# Limit used memory to 10 GB
ulimit -Sv 10000000

IFS=$'\n'

echo instance,method,cost > ${OUTPUT}
for instance in $(ls ${INSTANCE_DIR}/*.txt | sort -t"_" -n -k2 -k3)
do
    instance_short=$(basename "${instance}")
    echo ${instance_short}
    SECONDES=$(head -n 1 "${instance}" | cut -f1 -d" ")
    COST=10000000
    for method in ${PARTICIPANT_ROOT}/*.py
    do
        method_short=$(basename "${method}")
        echo ${instance_short},${method_short} 1>&2
        OUT=$(mktemp)
        if [[ ${method} == *.py ]]
        then
            timeout ${SECONDES} python "${method}" "${instance}" ${OUT} 1>&2
        elif [[ ${method} == *.c ]]
        then
            if [[ ! -f ${method}.out ]]
            then
                gcc -Ofast "${method}" -o "${method}.out" -lglpk 1>&2
            fi
            timeout ${SECONDES} "${method}.out" "${instance}" ${OUT} 1>&2
        else
            rm ${OUT}
            continue
        fi
        if [ $? -eq 0 ]
        then
            cost=$(python verifier.py "${instance}" ${OUT})
            echo ${instance_short},${method_short},${cost} >> ${OUTPUT}
            printf "  %-35s %15s" "${method_short}" "${cost}"
            if [ ${cost} -lt ${COST} ]
            then
                printf " best so far"
                COST=${cost}
            elif [ ${cost} -eq ${COST} ]
            then
                printf " (again)"
            fi
            printf "\n"
        else
            printf "  %-25s %15s\n" "${method_short}" "NA"
            echo ${instance_short},${method_short},NA >> ${OUTPUT}
        fi
        rm ${OUT}
    done
done
